<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';
$titulo = "Registro de Transporte";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?= $titulo ?> - Comercializadora Alimentos Oriente, C.A</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4;
      padding: 40px;
    }
    .container {
      max-width: 800px;
      margin: auto;
      background-color: #fff;
      padding: 30px;
      border-radius: 15px;
      box-shadow: 0 10px 20px rgba(0, 128, 0, 0.15);
    }
    h2 {
      color: #2e7d32;
      text-align: center;
    }
    label {
      display: block;
      margin-top: 15px;
      font-weight: 500;
    }
    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    button {
      margin-top: 20px;
      background-color: #2e7d32;
      color: white;
      padding: 12px 20px;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
    }
    button:hover {
      background-color: #1b5e20;
    }
    .telefono-group {
      display: flex;
      gap: 10px;
    }
  </style>
</head>
<body>
<div class="container">
  <h2>Registro de Transporte</h2>

  <form method="POST" action="procesar_transporte.php">

<label for="tipo_transporte">Tipo de Propietario:</label>
<select name="tipo_transporte" id="tipo_transporte" onchange="actualizarPrefijoTransporte()" required>
  <option value="">Seleccione tipo</option>
  <option value="natural">Natural</option>
  <option value="juridico">Jurídico</option>
  <option value="gubernamental">Gubernamental</option>
</select>

    
    <!-- RIF -->
    <label for="rif">RIF:</label>
<input 
  type="text" 
  name="rif" 
  id="rif" 
  placeholder="Ej: J-12345678" 
  required 
  oninput="validarRifTransporte(); verificarRif();">
<span id="rif-msg" style="color: red; font-size: 14px;"></span>



    <!-- Razon Social -->
    <label for="razon_social">Razón Social:</label>
    <input type="text" name="razon_social" id="razon_social" required>

    <!-- Dirección -->
    <label for="direccion">Dirección:</label>
    <textarea name="direccion" id="direccion" rows="2"></textarea>

    <!-- Chofer -->
    <label for="chofer">Chofer:</label>
    <input type="text" name="chofer" id="chofer" required>

    <!-- Cédula del chofer -->
    <label for="cedula_chofer">Cédula del Chofer:</label>
<input 
  type="text" 
  name="cedula_chofer" 
  id="cedula_chofer" 
  required 
  placeholder="V-12345678"
  value="V-"
  oninput="validarCedulaChofer();">
<span id="cedula-msg" style="color: red; font-size: 14px;"></span>

    <!-- Teléfono -->
    <label for="telefono">Teléfono:</label>
    <div class="telefono-group">
      <select name="telefono_prefijo" id="telefono_prefijo" required>
        <option value="">Prefijo</option>
        <option value="0412">0412</option>
        <option value="0414">0414</option>
        <option value="0416">0416</option>
        <option value="0424">0424</option>
        <option value="0426">0426</option>
      </select>
      <input type="text" name="telefono_numero" id="telefono_numero" required maxlength="7"
             placeholder="7 dígitos" oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- Vehículo -->
    <label for="vehiculo">Tipo de Vehículo:</label>
<select name="vehiculo" id="vehiculo" required>
  <option value="">Seleccione tipo de vehículo</option>
  <option value="CAMION CAVA">CAMIÓN CAVA</option>
  <option value="CAMION PLATAFORMA">CAMIÓN PLATAFORMA</option>
  <option value="CHUTO CON CONTENEDOR">CHUTO CON CONTENEDOR</option>
  <option value="CHUTO CON PLATAFORMA">CHUTO CON PLATAFORMA</option>
  <option value="PICK UP">PICK UP</option>
</select>


    <!-- Peso Tara -->
    <label for="peso_tara">Peso Tara (Kg):</label>
    <input type="number" step="0.01" name="peso_tara" id="peso_tara">

    <!-- Placas -->
    <label for="placa_chuto">Placa Chuto:</label>
    <input type="text" name="placa_chuto" id="placa_chuto">

    <label for="placa_batea">Placa Batea:</label>
    <input type="text" name="placa_batea" id="placa_batea">

    <!-- Botón -->
    <button type="submit" id="btn-guardar">Registrar Transporte</button>

    <!-- Volver -->
    <div style="text-align:center; margin-top:25px;">
      <a href="home.php"
         style="display:inline-block; background:#555; color:#fff;
                padding:10px 20px; border-radius:6px; text-decoration:none;">
        ⬅ Volver al Menú
      </a>
    </div>

  </form>
</div>

<script>
function actualizarPrefijoTransporte() {
  const tipo = document.getElementById('tipo_transporte').value;
  const rifInput = document.getElementById('rif');
  let prefijo = '';

  if (tipo === 'natural') {
    prefijo = 'V-';
  } else if (tipo === 'juridico') {
    prefijo = 'J-';
  } else if (tipo === 'gubernamental') {
    prefijo = 'G-';
  }

  rifInput.value = prefijo;
  rifInput.focus();
  rifInput.setSelectionRange(prefijo.length, prefijo.length);
  verificarRif(); // Verifica de inmediato
}

function validarRifTransporte() {
  const rifInput = document.getElementById('rif');
  const valor = rifInput.value;

  const match = valor.match(/^(V-|J-|G-)/i);
  const prefijo = match ? match[0] : '';
  const numeros = valor.substring(prefijo.length).replace(/\D/g, '');

  rifInput.value = prefijo + numeros;

  verificarRif(); // Verifica en tiempo real
}
</script>

</body>
</html>
