<?php
require 'db.php';

if (!isset($_GET['id'])) {
    die("ID de recepción no especificado.");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM recepcion_general WHERE id_recepcion = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$stmt->close();

if (!$data) {
    die("Recepción no encontrada.");
}

$stmt = $conn->prepare("SELECT cedula_chofer FROM transporte WHERE razon_social = ? AND chofer = ? LIMIT 1");
$stmt->bind_param("ss", $data['razon_transporte'], $data['chofer']);
$stmt->execute();
$stmt->bind_result($cedula_chofer);
$stmt->fetch();
$stmt->close();

session_start();
$procesado_por = $_SESSION['usuario'] ?? '';
$fecha = date("d/m/Y", strtotime($data['fecha'] ?? 'now'));
?>
<!DOCTYPE html>
<html lang="es">
<head>

  <meta charset="UTF-8">
  <title>Ticket de Pesaje</title>
<link href="https://fonts.googleapis.com/css2?family=Libre+Barcode+39&display=swap" rel="stylesheet">
  <style>
    body {
  font-family: monospace;
  width: 100%;
  margin: 0;
  padding: 0;
  font-size: 11px;
  text-transform: uppercase;
     }


    .center { text-align: center; }
    .bold { font-weight: bold; }

    .barcode {
      font-family: 'Libre Barcode 39', monospace;
      font-size: 48px;
      text-align: center;
      margin-top: 10px;
      margin-bottom: 10px;
    }

    hr {
      border: none;
      border-top: 1px dashed #000;
      margin: 5px 0;
    }

    .section-title {
      font-weight: bold;
      border-top: 1px solid #000;
      border-bottom: 1px solid #000;
      margin-top: 10px;
      padding: 3px 0;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    td {
      padding: 6px 0;
      vertical-align: top;
    }

    .datos-recepcion {
      width: 100%;
      font-family: monospace;
      font-size: 12px;
      margin-top: 5px;
      border-collapse: collapse;
    }

    .datos-recepcion td {
      padding: 8px 0;
      vertical-align: middle;
    }

    .datos-recepcion .linea {
      display: inline-block;
      border-bottom: 1px solid #000;
      width: 80px;
      height: 1em;
      margin-left: 8px;
    }
    
  </style>
</head>
<body>
<div class="barcode">
  *<?= htmlspecialchars($data['control']) ?>*
</div>
<div class="center bold">
  PLANTA DE HARINA DE MAIZ<br>
  COMERCIALIZADORA ALIMENTOS ORIENTE, C.A<br>
  J-506527553<br>
  CAICARA DE MATURIN - EDO. MONAGAS
</div>

<hr>
<div class="center bold">TICKET DE PESAJE</div>
<hr>

<!-- 1. DATOS -->
<div class="section-title">DATOS</div>
<table>
  <tr><td>FECHA</td><td>: <?= $fecha ?></td></tr>
  <tr><td>GUIA DESPACHO</td><td>: <?= htmlspecialchars($data['guia_sada']) ?></td></tr>
  <tr><td>CONTROL</td><td>: <?= htmlspecialchars($data['control']) ?></td></tr>
</table>

<!-- 2. CHOFER -->
<div class="section-title">CHOFER</div>
<table>
  <tr><td>CEDULA</td><td>: <?= htmlspecialchars($cedula_chofer) ?></td></tr>
  <tr><td>NOMBRE</td><td>: <?= htmlspecialchars($data['chofer']) ?></td></tr>
</table>

<!-- 3. VEHÍCULO -->
<div class="section-title">VEHICULO</div>
<table>
  <tr><td>TIPO</td><td>: <?= htmlspecialchars($data['vehiculo']) ?></td></tr>
  <tr><td>PLACA CHUTO</td><td>: <?= htmlspecialchars($data['placa_chuto']) ?></td></tr>
  <tr><td>PLACA BATEA</td><td>: <?= htmlspecialchars($data['placa_batea']) ?></td></tr>
</table>

<!-- 4. RECEPCION - EN BLANCO PARA LLENAR A MANO -->
<div class="section-title">RECEPCION</div>
<table class="datos-recepcion">
  <tr><td>CANTIDAD</td><td>:<span class="linea"></span></td></tr>
  <tr><td>PESO BRUTO</td><td>:<span class="linea"></span></td></tr>
  <tr><td>PESO TARA</td><td>:<span class="linea"></span></td></tr>
  <tr><td>PESO NETO</td><td>:<span class="linea"></span></td></tr>
</table>

<!-- 5. OBSERVACION -->
<div class="section-title">OBSERVACION</div>
<div style="min-height:40px; border-bottom: 1px solid #000;"></div>

<!-- 6. PROCESADO POR -->
<div class="section-title">PROCESADO POR</div>
<div><?= htmlspecialchars($procesado_por) ?></div>

<!-- 7. REVISADO POR -->
<div class="section-title">REVISADO POR</div>
<div style="min-height:20px; border-bottom: 1px solid #000;"></div>

<!-- 8. SELLO -->
<div class="section-title">SELLO</div>
<div style="min-height:20px; border-bottom: 1px solid #000;"></div>

<script>
  window.print();
</script>

</body>
</html>
