<?php
session_start();

// Validar sesión
if (!isset($_SESSION["id_usuario"])) {
    header("Location: login.php");
    exit();
}

require 'db.php';

$busqueda = isset($_GET['busqueda']) ? trim($_GET['busqueda']) : "";
$filtro_almacen = isset($_GET['almacen']) ? trim($_GET['almacen']) : "";

// 1. Obtener lista de almacenes para el select del filtro
$sql_almacenes = "SELECT DISTINCT almacen FROM stock ORDER BY almacen ASC";
$res_almacenes = $conn->query($sql_almacenes);

// 2. Construir la consulta del inventario con filtros dinámicos
$sql = "SELECT * FROM stock WHERE 1=1";
$params = [];
$types = "";

if ($busqueda !== "") {
    $sql .= " AND (codigo LIKE ? OR descripcion LIKE ?)";
    $term = "%" . $busqueda . "%";
    $params[] = $term;
    $params[] = $term;
    $types .= "ss";
}

if ($filtro_almacen !== "") {
    $sql .= " AND almacen = ?";
    $params[] = $filtro_almacen;
    $types .= "s";
}

$sql .= " ORDER BY almacen ASC, descripcion ASC";

$stmt = $conn->prepare($sql);

// Si hay parámetros, los vinculamos dinámicamente
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$resultado = $stmt->get_result();
$inventario = $resultado->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Calcular total general de la vista actual
$total_general = 0;
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Reporte de Inventario</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 1200px;
      margin: auto;
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32;
      margin-bottom: 20px;
    }
    label {
      font-weight: 500;
      color: #2e7d32;
    }
    .form-control, .form-select {
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    .boton {
      padding: 8px 15px;
      background-color: #2e7d32;
      color: white;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      text-decoration: none;
      display: inline-block;
      transition: background 0.3s;
    }
    .boton:hover {
      background-color: #1b5e20;
      color: white;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 25px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: center;
      vertical-align: middle;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
      font-weight: bold;
    }
    tr:hover {
      background-color: #f1f8e9;
    }
    .total-row {
      background-color: #c8e6c9;
      font-weight: bold;
      color: #1b5e20;
    }
    .filtros {
      background-color: #f9fbe7;
      padding: 15px;
      border-radius: 8px;
      border: 1px solid #e0e0e0;
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      align-items: end;
    }
  </style>
</head>
<body>

<div class="container">
  <h2>📦 Reporte de Inventario Actual</h2>

  <form method="GET" class="filtros">
    <div class="flex-grow-1">
        <label for="busqueda">Buscar (Código o Descripción):</label>
        <input type="text" name="busqueda" id="busqueda" class="form-control" value="<?= htmlspecialchars($busqueda) ?>" placeholder="Escribe para buscar...">
    </div>
    
    <div style="min-width: 200px;">
        <label for="almacen">Filtrar por Almacén:</label>
        <select name="almacen" id="almacen" class="form-select">
            <option value="">-- Todos los Almacenes --</option>
            <?php while ($row = $res_almacenes->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($row['almacen']) ?>" <?= $filtro_almacen == $row['almacen'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($row['almacen']) ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>

    <div>
        <button type="submit" class="boton">🔍 Buscar</button>
        <a href="stock_almacen.php" class="boton" style="background-color: #757575;">Limpiar</a>
        <a href="home.php" class="boton" style="background-color: #1565c0;">🏠 Volver</a>
    </div>
  </form>

  <?php if (count($inventario) > 0): ?>
      <table>
        <thead>
          <tr>
            <th>Código</th>
            <th>Descripción</th>
            <th>Presentación</th>
            <th>Almacén</th>
            <th>Existencia</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($inventario as $item): 
              // Sumar al total general
              $total_general += $item['cantidad'];
          ?>
            <tr>
              <td><?= htmlspecialchars($item['codigo']) ?></td>
              <td style="text-align: left;"><?= htmlspecialchars($item['descripcion']) ?></td>
              <td><?= htmlspecialchars($item['presentacion']) ?></td>
              <td><span class="badge bg-secondary"><?= htmlspecialchars($item['almacen']) ?></span></td>
              
              <td style="font-weight: bold; color: <?= $item['cantidad'] <= 0 ? 'red' : '#2e7d32' ?>;">
                <?= number_format($item['cantidad'], 2, ',', '.') ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="4" style="text-align: right;">TOTAL GENERAL:</td>
                <td><?= number_format($total_general, 2, ',', '.') ?></td>
            </tr>
        </tfoot>
      </table>
  <?php else: ?>
      <div class="alert alert-warning mt-4 text-center">
          No se encontraron productos en el inventario con los criterios seleccionados.
      </div>
  <?php endif; ?>

</div>

</body>
</html>