<?php
session_start();
require 'db.php';

// Consulta de recepciones abiertas
$query = "
SELECT 
    rg.id_recepcion,
    rg.fecha_recepcion,
    rg.control,
    rg.guia_sada,
    rg.rif_proveedor,
    p.razon_social AS nombre_proveedor,
    rg.vehiculo,
    rg.chofer,
    rg.placa_chuto,
    rg.status
FROM recepcion_general rg
LEFT JOIN proveedor p ON rg.rif_proveedor = p.cedula
WHERE rg.status = 'ABIERTO'
ORDER BY rg.fecha_recepcion DESC
";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Status de Recepciones</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 1200px;
      margin: auto;
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: center;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
    }
    .btn {
      padding: 5px 10px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 13px;
    }
    .btn-accion {
      background-color: #388e3c;
      color: white;
    }
    .btn-imprimir {
      background-color: #1976d2;
      color: white;
    }
    .btn-detalle {
      background-color: #f9a825;
      color: white;
    }
  </style>
</head>

<body>
<div class="container">
  <h2>Recepcion Materia Prima Status "Abiertas"</h2>

  <table>
    <thead>
      <tr>
        <th>Fecha</th>
        <th>Control</th>
        <th>Guía Despacho</th>
        <th>Proveedor</th>
        <th>Vehículo</th>
        <th>Chofer</th>
        <th>Placa Chuto</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
          <td><?= date("d/m/Y", strtotime($row['fecha_recepcion'])) ?></td>
          <td><?= htmlspecialchars($row['control']) ?></td>
          <td><?= htmlspecialchars($row['guia_sada']) ?></td>
          <td><?= htmlspecialchars($row['nombre_proveedor']) ?></td>
          <td><?= htmlspecialchars($row['vehiculo']) ?></td>
          <td><?= htmlspecialchars($row['chofer']) ?></td>
          <td><?= htmlspecialchars($row['placa_chuto']) ?></td>
          <td>
            <!-- Botón APROBAR -->
            <form action="aprobar_recepcion.php" method="post" style="display:inline;">
              <input type="hidden" name="id_recepcion" value="<?= $row['id_recepcion'] ?>">
              <button type="submit" class="btn btn-accion">Aprobar</button>
            </form>
            <!-- Botón IMPRIMIR -->
            <a href="ticket_pesaje.php?id=<?= $row['id_recepcion'] ?>" target="_blank" class="btn btn-imprimir">Imprimir</a>

            <!-- Botón DETALLE -->
            <button class="btn btn-detalle ver-detalle" data-id="<?= $row['id_recepcion'] ?>">Detalle</button>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<!-- Modal Detalle Recepción -->
<div class="modal fade" id="modalDetalle" tabindex="-1" aria-labelledby="modalDetalleLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detalle de Recepción</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <table class="table table-bordered">
          <thead>
            <tr>
              <th>Descripción</th>
              <th>Cantidad</th>
              <th>Peso Bruto Kg</th>
              <th>Peso Tara Kg</th>
              <th>Peso Neto Kd</th>
            </tr>
          </thead>
          <tbody id="tablaDetalle">
            <!-- Datos se insertarán dinámicamente -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
$(document).on('click', '.ver-detalle', function () {
  const id = $(this).data('id');

  $.post("obtener_detalle_recepcion.php", { id: id }, function (res) {
    if (res.success) {
      let filas = '';
      res.detalles.forEach(item => {
        filas += `<tr>
          <td>${item.descripcion}</td>
          <td>${item.cantidad}</td>
          <td>${item.peso_bruto}</td>
          <td>${item.peso_tara}</td>
          <td>${item.peso_neto}</td>
        </tr>`;
      });
      $('#tablaDetalle').html(filas);
      const modal = new bootstrap.Modal(document.getElementById('modalDetalle'));
      modal.show();
    } else {
      alert("No se pudo obtener el detalle.");
    }
  }, 'json');
});
</script>

</body>
</html>
