<?php
session_start();

// Validar sesión
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

// Para el campo oculto 'usuario'
$usuario_actual = $_SESSION["nombre"];

// Manejo de mensajes de éxito o error (si se redirige desde el procesador)
$mensaje = "";
$mensaje_tipo = ""; // 'success' o 'error'

if (isset($_GET['success'])) {
    $mensaje = "✅ ¡Cliente registrado con éxito!";
    $mensaje_tipo = "success";
}
if (isset($_GET['error'])) {
    $mensaje = "❌ Error al registrar el cliente. Cédula/RIF duplicado o datos inválidos.";
    $mensaje_tipo = "error";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Registrar Nuevo Cliente</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4; /* Fondo verde claro */
      padding: 40px 20px;
    }
    .container {
      max-width: 900px; /* Un poco más ancho para este form */
      margin: auto;
      background: #fff;
      padding: 30px 40px;
      border-radius: 15px;
      box-shadow: 0 10px 25px rgba(0, 128, 0, 0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32; /* Verde principal */
      margin-bottom: 30px;
      font-weight: 700;
    }
    .form-label {
      font-weight: 600;
      color: #2e7d32;
    }
    .form-control, .form-select {
      border: 1px solid #ccc;
      border-radius: 8px;
      padding: 10px 15px;
    }
    .form-control:focus, .form-select:focus {
      border-color: #2e7d32;
      box-shadow: 0 0 0 0.25rem rgba(46, 125, 50, 0.25);
    }
    .boton {
      padding: 12px 20px;
      font-size: 16px;
      background-color: #2e7d32;
      color: white;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      display: inline-block;
      transition: background-color 0.3s;
      width: 100%;
      font-weight: 600;
    }
    .boton:hover {
      background-color: #1b5e20;
    }
    .boton-volver {
      display: inline-block;
      text-decoration: none;
      color: #555;
      margin-top: 20px;
      font-size: 15px;
    }
    .boton-volver i {
      margin-right: 5px;
    }
    .boton-volver:hover {
      color: #2e7d32;
    }
    .alert-success {
        background-color: #e8f5e9;
        color: #1b5e20;
        border-color: #c8e6c9;
    }
    .alert-error {
        background-color: #fbe9e7;
        color: #b71c1c;
        border-color: #ffcdd2;
    }
  </style>
</head>
<body>

  <div class="container">
    <h2><i class="bi bi-person-plus-fill"></i> Registrar Nuevo Cliente</h2>

    <?php if ($mensaje): ?>
        <div class="alert <?= $mensaje_tipo === 'success' ? 'alert-success' : 'alert-error' ?>" role="alert">
            <?= htmlspecialchars($mensaje) ?>
        </div>
    <?php endif; ?>

    <form action="procesar_cliente.php" method="POST">
      
      <input type="hidden" name="usuario" value="<?= htmlspecialchars($usuario_actual) ?>">
      <input type="hidden" name="fecha_status" value="<?= date('Y-m-d') ?>">

      <div class="row g-3">
        
        <div class="col-md-4">
          <label for="tipo_cliente" class="form-label">Tipo de Cliente:</label>
          <select class="form-select" id="tipo_cliente" name="tipo_cliente" required>
            <option value="" disabled selected>-- Seleccione --</option>
            <option value="Persona Natural">Persona Natural</option>
            <option value="Juridico">Juridico</option>
            <option value="Gubernamental">Gubernamental</option>
            <option value="Otro">Otro</option>
          </select>
        </div>

        <div class="col-md-4">
          <label for="cedula" class="form-label">Cédula / RIF:</label>
          <input type="text" class="form-control" id="cedula" name="cedula" placeholder="Seleccione un tipo" required>
        </div>
        
        <div class="col-md-4">
          <label for="status" class="form-label">Estatus:</label>
          <select class="form-select" id="status" name="status" required>
            <option value="Activo" selected>Activo</option>
            <option value="Inactivo">Inactivo</option>
            <option value="Suspendido">Suspendido</option>
          </select>
        </div>

        <div class="col-md-12">
          <label for="razon_social" class="form-label">Razón Social:</label>
          <input type="text" class="form-control" id="razon_social" name="razon_social" placeholder="Nombre completo o de la empresa" required>
        </div>

        <div class="col-md-6">
          <label for="persona_contacto" class="form-label">Persona Contacto:</label>
          <input type="text" class="form-control" id="persona_contacto" name="persona_contacto">
        </div>

        <div class="col-md-6">
          <label for="telefono" class="form-label">Teléfono:</label>
          <input type="text" class="form-control" id="telefono" name="telefono" placeholder="Ej: 0414-1234567">
        </div>

        <div class="col-md-12">
          <label for="direccion" class="form-label">Dirección:</label>
          <textarea class="form-control" id="direccion" name="direccion" rows="3" placeholder="Dirección fiscal o de despacho"></textarea>
        </div>

      </div>

      <button type="submit" class="boton mt-4"><i class="bi bi-check-lg"></i> Guardar Cliente</button>
    </form>

    <div class="text-center">
        <a href="home.php" class="boton-volver"><i class="bi bi-arrow-left-circle"></i> Volver al Inicio</a>
    </div>
  </div>

<script>
// Esperar a que todo el HTML esté cargado
document.addEventListener('DOMContentLoaded', function() {
    
    // 1. Encontrar los dos campos
    const tipoClienteSelect = document.getElementById('tipo_cliente');
    const cedulaInput = document.getElementById('cedula');

    // 2. Escuchar cuando el usuario cambie el "Tipo de Cliente"
    tipoClienteSelect.addEventListener('change', function() {
        
        const tipoSeleccionado = this.value; // Ej: "Persona Natural"
        let prefijo = '';

        // 3. Asignar el prefijo basado en la selección
        if (tipoSeleccionado === 'Persona Natural') {
            prefijo = 'V-';
        } else if (tipoSeleccionado === 'Juridico') {
            prefijo = 'J-';
        } else if (tipoSeleccionado === 'Gubernamental') {
            prefijo = 'G-';
        } else {
            prefijo = ''; // Dejarlo vacío si es "Otro" o no seleccionado
        }

        // 4. Poner el prefijo en el campo Cédula y mover el cursor allí
        cedulaInput.value = prefijo;
        cedulaInput.placeholder = 'Ingrese el número'; // Actualizar el placeholder
        cedulaInput.focus(); // Poner el cursor listo para escribir
    });
});
</script>

</body>
</html>