<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}
require 'db.php';

// Obtener el formato base (ej: 0000001)
$formato_base = '0000001';
$res = $conn->query("SELECT valor FROM configuracion_general WHERE nombre = 'formato_control'");
if ($row = $res->fetch_assoc()) {
    $formato_base = $row['valor'];
}

// Obtener el último número de control guardado
$res = $conn->query("SELECT control FROM recepcion_general ORDER BY id_recepcion DESC LIMIT 1");
$ultimo_control = $res->fetch_assoc();
$numero = 1;

if ($ultimo_control && preg_match('/(\d+)$/', $ultimo_control['control'], $matches)) {
    $numero = intval($matches[1]) + 1;
}

// Mantener formato de ceros
$control_generado = str_pad($numero, strlen($formato_base), '0', STR_PAD_LEFT);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Recepción de Materiales</title>
  
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  
  <style>
    /* Estilos personalizados (manteniendo tu paleta de colores) */
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 1100px;
      margin: auto;
      background: #fff;
      padding: 35px 40px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2, h3 {
      color: #2e7d32;
      margin-bottom: 20px;
    }
    h2 { text-align: center; }
    
    fieldset {
      border: 1px solid #ccc;
      padding: 20px;
      margin-bottom: 20px;
      border-radius: 6px;
    }
    legend {
      font-weight: bold;
      color: #2e7d32;
      padding: 0 10px;
    }
    
    /* Botones */
    .boton {
      background-color: #2e7d32;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      margin-top: 20px;
      text-decoration: none;
      display: inline-block;
    }
    .boton:hover {
      background-color: #1b5e20;
      color: white;
    }
    
    /* Estilos para la tabla de productos (aquí mantenemos tus anchos fijos) */
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: left;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
    }
    table input, table select {
      padding: 5px;
      font-size: 13px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    td input, td select {
      width: 100px;
    }
    td select.select-producto {
      width: 180px !important;
    }
    
    /* Número de Control */
    .control-box {
      text-align: center;
      margin-bottom: 20px;
    }
    #control {
      font-size: 24px;
      font-weight: bold;
      text-align: center;
      width: 180px;
      padding: 8px;
      border: none;
      background: #e8f5e9;
      color: #2e7d32;
      border-radius: 8px;
    }
    .control-box label {
        font-size: 18px;
        font-weight: 500;
        color: #2e7d32;
        display: block;
        margin-bottom: 5px;
    }
    
    /* Estilos del Modal (sin cambios) */
    .modal {
      position: fixed; top: 0; left: 0; width: 100%; height: 100%;
      background-color: rgba(0,0,0,0.6); display: flex;
      align-items: center; justify-content: center; z-index: 9999;
    }
    .modal-contenido {
      background: #fff; padding: 30px; border-radius: 10px;
      text-align: center; max-width: 400px; width: 90%;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3); font-family: 'Segoe UI', sans-serif;
    }
    .modal-contenido h3 { color: #2e7d32; font-size: 22px; margin-bottom: 10px; }
    .modal-contenido p { font-size: 16px; margin-bottom: 20px; }
    .modal .botones { display: flex; flex-direction: column; gap: 10px; }
    .modal .boton { background-color: #2e7d32; color: white; text-decoration: none; padding: 10px 20px; border-radius: 5px; font-weight: bold; }
    .modal .boton:hover { background-color: #1b5e20; }
    .modal .boton.imprimir { background-color: #0277bd; }
    .modal .boton.imprimir:hover { background-color: #01579b; }

    /* Corrección para Select2 con Bootstrap */
    .select2-container--default .select2-selection--single {
        border: 1px solid #ced4da;
        height: calc(2.25rem + 10px);
        padding: 8px 12px;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: calc(2.25rem + 8px);
    }
  </style>
</head>
<body>

<?php if (isset($_GET['success']) && $_GET['success'] == 1 && isset($_GET['id'])): ?>
  <div id="modal-exito" class="modal">
    <div class="modal-contenido">
      <h3>✅ Recepción registrada correctamente</h3>
      <p>¿Qué deseas hacer a continuación?</p>
      <div class="botones">
        <a href="recepcion.php" class="boton">Registrar nueva recepción</a>
        <a href="ticket_pesaje.php?id=<?= intval($_GET['id']) ?>" target="_blank" class="boton imprimir">🖨️ Imprimir Ticket de Pesaje</a>
      </div>
    </div>
  </div>
<?php endif; ?>


<div class="container">
  <h2>Recepción de Materia Prima</h2>
  <form method="post" action="procesar_recepcion.php">

    <div class="control-box">
      <label for="control">Control N°:</label>
      <input type="text" name="control" id="control" value="<?= $control_generado ?>" readonly>
    </div>

    <fieldset>
      <legend>Datos del Proveedor</legend>
      <div class="row g-3"> <div class="col-md-6">
          <label for="proveedor" class="form-label">Razón Social:</label>
          <select id="proveedor" name="rif_proveedor" class="form-select" required>
            <option value="">-- Seleccione proveedor --</option>
            <?php
            $res = $conn->query("SELECT cedula, razon_social FROM proveedor ORDER BY razon_social ASC");
            while ($prov = $res->fetch_assoc()):
            ?>
              <option value="<?= $prov['cedula'] ?>"><?= htmlspecialchars($prov['razon_social']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        
        <div class="col-md-6">
          <label for="cedula_proveedor" class="form-label">RIF / Cédula:</label>
          <input type="text" name="cedula_proveedor" id="cedula_proveedor" class="form-control" readonly>
        </div>
        
        <div class="col-md-6">
          <label for="direccion_proveedor" class="form-label">Dirección:</label>
          <input type="text" name="direccion_proveedor" id="direccion_proveedor" class="form-control" readonly>
        </div>
        
        <div class="col-md-6">
          <label for="contacto_proveedor" class="form-label">Persona Contacto:</label>
          <input type="text" name="contacto_proveedor" id="contacto_proveedor" class="form-control" readonly>
        </div>
        
        <div class="col-md-6">
          <label for="doc_referencia" class="form-label">Doc. Referencia:</label>
          <input type="text" name="doc_referencia" id="doc_referencia" class="form-control" placeholder="Ej: Factura 001234" required>
        </div>
        
        <div class="col-md-6">
          <label for="guia_sada" class="form-label">Guía SADA:</label>
          <input type="text" name="guia_sada" id="guia_sada" class="form-control" placeholder="Ej: G-456789" required>
        </div>
        
      </div>
    </fieldset>

    <fieldset>
      <legend>Datos del Transporte</legend>
      <div class="row g-3">
        
        <div class="col-md-6">
          <label for="razon_transporte" class="form-label">Razón Social Transporte:</label>
          <select id="razon_transporte" name="razon_transporte" class="form-select" required>
            <option value="">-- Seleccione empresa transporte --</option>
            <?php
            $empresas = $conn->query("SELECT DISTINCT razon_social FROM transporte ORDER BY razon_social ASC");
            while ($row = $empresas->fetch_assoc()):
            ?>
              <option value="<?= htmlspecialchars($row['razon_social']) ?>"><?= htmlspecialchars($row['razon_social']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        
        <div class="col-md-6">
          <label for="chofer" class="form-label">Chofer:</label>
          <select id="chofer" name="chofer" class="form-select" required>
            <option value="">-- Seleccione chofer --</option>
          </select>
        </div>
        
        <div class="col-md-4">
          <label for="vehiculo" class="form-label">Vehículo:</label>
          <select id="vehiculo" name="vehiculo" class="form-select" required>
            <option value="">-- Vehículo asignado --</option>
          </select>
        </div>
        
        <div class="col-md-4">
          <label for="placa_chuto" class="form-label">Placa Chuto:</label>
          <select name="placa_chuto" id="placa_chuto" class="form-select" required>
            <option value="">-- Seleccione placa chuto --</option>
          </select>
        </div>
        
        <div class="col-md-4">
          <label for="placa_batea" class="form-label">Placa Batea:</label>
          <select name="placa_batea" id="placa_batea" class="form-select" required>
            <option value="">-- Seleccione placa batea --</option>
          </select>
        </div>

      </div>
    </fieldset>

    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label for="almacen" class="form-label">Almacén de Resguardo:</label>
        <select name="almacen" id="almacen" class="form-select" required>
          <option value="">Seleccione</option>
          <?php
          $alm = $conn->query("SELECT descripcion FROM almacenes ORDER BY descripcion ASC");
          while ($a = $alm->fetch_assoc()):
          ?>
            <option value="<?= $a['descripcion'] ?>"><?= htmlspecialchars($a['descripcion']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label for="observaciones" class="form-label">Observaciones:</label>
        <textarea name="observaciones" id="observaciones" class="form-control" rows="1"></textarea>
      </div>
    </div>

    <h3>Detalle de Productos</h3>
    <table class="table table-bordered table-hover">
      <thead>
        <tr>
          <th>Código</th>
          <th>Descripción</th>
          <th>Presentación</th>
          <th>Cantidad</th>
          <th>Peso Bruto</th>
          <th>Peso Tara</th>
          <th>Peso Neto</th>
          <th>Acción</th>
        </tr>
      </thead>
      <tbody id="tabla-productos">
        <tr>
          <td><input type="text" name="codigo[]" class="codigo" readonly></td>
          <td>
            <select name="descripcion[]" class="select-producto descripcion" required>
              <option value="">-- Buscar producto --</option>
              <?php
              $res = $conn->query("SELECT * FROM productos ORDER BY descripcion ASC");
              while ($p = $res->fetch_assoc()):
              ?>
                <option value="<?= htmlspecialchars($p['descripcion']) ?>" 
                        data-codigo="<?= $p['codigo'] ?>" 
                        data-categoria="<?= $p['categoria'] ?>" 
                        data-presentacion="<?= $p['presentacion'] ?>">
                  <?= htmlspecialchars($p['descripcion']) ?>
                </option>
              <?php endwhile; ?>
            </select>
           </td>
          <td><input type="text" name="presentacion[]" class="presentacion" readonly></td>
          <td><input type="text" name="cantidad[]" class="cantidad"></td>
          <td><input type="text" name="peso_bruto[]" class="bruto"></td>
          <td><input type="text" name="peso_tara[]" class="tara"></td>
          <td><input type="text" name="peso_neto[]" class="neto" readonly></td>
          <td>
            <button type="button" onclick="agregarFila()" class="btn btn-success btn-sm">➕</button>
            <button type="button" class="eliminar-fila btn btn-danger btn-sm">🗑️</button>
          </td>
        </tr>
      </tbody>
    </table>

    <div style="margin-top:30px; text-align:center;">
      <button type="submit" class="boton">Guardar Recepción</button>
      <a href="home.php" class="boton" style="background:#555;">⬅ Volver</a>
    </div>
  </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function () {
  // 1. Inicializar TODOS los Select2
  $('#proveedor, #razon_transporte, #chofer, .select-producto, #vehiculo, #placa_chuto, #placa_batea, #almacen').select2({
      width: '100%' // Forzar Select2 a tomar el ancho de Bootstrap
  });

  // 2. Lógica de Proveedor
  $('#proveedor').on('change', function () {
    let rif = $(this).val();
    if (!rif) return;
    $.post("consultar_proveedor.php", { rif: rif }, function (response) {
      if (response.success) {
        $('#cedula_proveedor').val(response.data.cedula);
        $('#direccion_proveedor').val(response.data.direccion);
        $('#contacto_proveedor').val(response.data.persona_contacto);
      }
    }, 'json');
  });

  // 3. Lógica de Transporte
  $('#razon_transporte').on('change', function () {
    let razon = $(this).val();
    
    // Resetear selects dependientes
    $('#chofer').empty().append('<option value="">-- Seleccione chofer --</option>');
    $('#vehiculo').empty().append('<option value="">-- Vehículo asignado --</option>');
    $('#placa_chuto').empty().append('<option value="">-- Seleccione placa chuto --</option>');
    $('#placa_batea').empty().append('<option value="">-- Seleccione placa batea --</option>');

    if (!razon) {
        $('#chofer, #vehiculo, #placa_chuto, #placa_batea').trigger('change'); // Notificar a Select2
        return;
    }

    $.post("consultar_transportes.php", { razon_social: razon }, function (response) {
      if (response.success) {
        // Llenar Choferes
        response.choferes.forEach(ch => {
          $('#chofer').append(`<option value="${ch}">${ch}</option>`);
        });
        // Llenar Vehículos
        response.vehiculos.forEach(v => {
          $('#vehiculo').append(`<option value="${v}">${v}</option>`);
        });
      }
      // Notificar a Select2 que los selects han cambiado
      $('#chofer, #vehiculo, #placa_chuto, #placa_batea').trigger('change');
    }, 'json');
  });

  // 4. Lógica de Chofer
  $('#chofer').on('change', function () {
    let razon = $('#razon_transporte').val();
    let chofer = $(this).val();
    
    if (!razon || !chofer) {
        return;
    }

    $.post("consultar_chofer.php", { razon_social: razon, chofer: chofer }, function (response) {
      if (response.success) {
        // Asignar vehículo
        $('#vehiculo').empty().append(`<option value="${response.data.vehiculo}">${response.data.vehiculo}</option>`);
        $('#vehiculo').val(response.data.vehiculo).trigger('change'); // Asignar Y NOTIFICAR
        
        // Asignar placa chuto
        $('#placa_chuto').empty().append(`<option value="${response.data.placa_chuto}">${response.data.placa_chuto}</option>`);
        $('#placa_chuto').val(response.data.placa_chuto).trigger('change'); // Asignar Y NOTIFICAR
        
        // Asignar placa batea
        let placaBatea = response.data.placa_batea || '';
        $('#placa_batea').empty().append(`<option value="${placaBatea}">${placaBatea}</option>`);
        $('#placa_batea').val(placaBatea).trigger('change'); // Asignar Y NOTIFICAR
      }
    }, 'json');
  });

  // 5. Lógica de Vehículo
  $('#vehiculo').on('change', function () {
    const razon = $('#razon_transporte').val();
    const vehiculo = $(this).val();
    
    // Resetear placas
    $('#placa_chuto').empty().append('<option value="">-- Placa chuto --</option>');
    $('#placa_batea').empty().append('<option value="">-- Placa batea --</option>');

    if (!razon || !vehiculo) {
        $('#placa_chuto, #placa_batea').trigger('change');
        return;
    }

    $.post("consultar_placas.php", {
      razon_social: razon,
      vehiculo: vehiculo
    }, function (response) {
      if (response.success) {
        response.placas_chuto.forEach(function (placa) {
          $('#placa_chuto').append(`<option value="${placa}">${placa}</option>`);
        });

        response.placas_batea.forEach(function (placa) {
          $('#placa_batea').append(`<option value="${placa}">${placa}</option>`);
        });
      }
      // Notificar a Select2
      $('#placa_chuto, #placa_batea').trigger('change');
    }, 'json');
  });

  // 6. Lógica de Producto
  $(document).on('change', '.select-producto', function () {
    const selected = $(this).find('option:selected');
    const row = $(this).closest('tr');
    row.find('.codigo').val(selected.data('codigo') || '');
    row.find('.presentacion').val(selected.data('presentacion') || '');
  });
  
}); // Fin de $(document).ready
</script>

<script>
function agregarFila() {
  // 1. Clonar la PRIMERA fila
  const nuevaFila = $('#tabla-productos tr:first').clone(); 
  
  // 2. Limpiar todos los inputs de texto
  nuevaFila.find('input').val('');
  
  // 3. Encontrar el <select> clonado
  const selectClonado = nuevaFila.find('.select-producto');
  
  // 4. (NUEVO PASO CRUCIAL) Eliminar la interfaz gráfica de Select2 clonada
  // Esta interfaz es un <span class="select2-container..."> que está al lado del <select>
  // Usamos .next() porque sabemos que Select2 lo pone justo después.
  selectClonado.next('.select2-container').remove();
  
  // 5. Destruir cualquier instancia de Select2 que "recuerde"
  if (selectClonado.data('select2')) {
    selectClonado.select2('destroy');
  }
  
  // 6. Forzar el reseteo del <select> de HTML
  selectClonado.find('option').removeAttr('selected');
  selectClonado.val(''); 
  selectClonado.prop('selectedIndex', 0);

  // 7. Agregar la fila (ya limpia) a la tabla
  $('#tabla-productos').append(nuevaFila);
  
  // 8. Reinicializar Select2 en el <select> limpio
  selectClonado.select2({
      width: '100%'
  });
}

// Eliminar fila de producto
$(document).on('click', '.eliminar-fila', function () {
  const totalFilas = $('#tabla-productos tr').length;
  if (totalFilas > 1) {
    $(this).closest('tr').remove();
  } else {
    alert('Debe haber al menos una fila en la tabla.');
  }
});

// Lógica de formato de números (sin cambios)
function formatearMilesDecimal(input) {
  let valor = input.value.replace(/\./g, '').replace(',', '.');
  if (!isNaN(valor) && valor !== '') {
    let numero = parseFloat(valor).toFixed(2);
    input.value = new Intl.NumberFormat('es-VE', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    }).format(numero);
  }
}

$(document).on('blur', '.cantidad, .bruto, .tara, .neto', function () {
  formatearMilesDecimal(this);
});

$(document).on('input', '.bruto, .tara', function () {
  const row = $(this).closest('tr');
  const brutoStr = row.find('.bruto').val().replace(/\./g, '').replace(',', '.');
  const taraStr = row.find('.tara').val().replace(/\./g, '').replace(',', '.');
  const bruto = parseFloat(brutoStr) || 0;
  const tara = parseFloat(taraStr) || 0;
  const neto = bruto - tara;

  if (neto >= 0) {
    row.find('.neto').val(
      new Intl.NumberFormat('es-VE', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      }).format(neto)
    );
  } else {
    row.find('.neto').val('0,00');
  }
});
</script>

</body>
</html>