<?<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

include 'db.php';
$titulo = "Proveedores";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?= $titulo ?> - Comercializadora Alimentos Oriente, C.A</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4;
      padding: 40px;
    }
    .container {
      max-width: 900px;
      margin: auto;
      background-color: #fff;
      padding: 30px;
      border-radius: 15px;
      box-shadow: 0 10px 20px rgba(0, 128, 0, 0.15);
    }
    h2 {
      color: #2e7d32;
      text-align: center;
    }
    form {
      margin-bottom: 40px;
    }
    label {
      display: block;
      margin-top: 15px;
      font-weight: 500;
    }
    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    button {
      margin-top: 20px;
      background-color: #2e7d32;
      color: white;
      padding: 12px 20px;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
    }
    button:disabled {
      background-color: #9e9e9e;
      cursor: not-allowed;
    }
    button:hover:enabled {
      background-color: #1b5e20;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
    }
    #cedula-msg {
      font-size: 14px;
      display: block;
      margin-top: 5px;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Registrar Proveedor</h2>
    <form method="POST" action="procesar_proveedor.php">

      <!-- Tipo -->
      <label for="tipo_proveedor">Tipo de Proveedor:</label>
      <select name="tipo_proveedor" id="tipo_proveedor" required onchange="actualizarPrefijo()">
	<option value="" disabled selected>Seleccione tipo</option>
        <option value="natural">Natural</option>
        <option value="juridico">Jurídico</option>
        <option value="gubernamental">Gubernamental</option>
      </select>

      <!-- RIF/Cédula -->
      <label for="cedula">Cédula / RIF:</label>
      <input type="text" name="cedula" id="cedula" required
             placeholder="Ej: V-12345678"
             oninput="validarNumeros(); verificarCedula();">
      <span id="cedula-msg"></span>

      <label for="razon_social">Razón Social:</label>
      <input type="text" name="razon_social" required>

      <label for="persona_contacto">Persona Contacto:</label>
      <input type="text" name="persona_contacto">

      <label for="direccion">Dirección:</label>
      <textarea name="direccion" rows="2"></textarea>

      
	<label for="telefono">Teléfono:</label>
<div style="display: flex; gap: 10px;">
  <select name="telefono_prefijo" id="telefono_prefijo" required>
    <option value="">Operadora</option>
    <option value="0412">0412</option>
    <option value="0414">0414</option>
    <option value="0424">0424</option>
    <option value="0416">0416</option>
    <option value="0426">0426</option>
  </select>
  
  <input type="text" name="telefono_numero" id="telefono_numero" required
         maxlength="7" placeholder="7 dígitos"
         oninput="this.value = this.value.replace(/[^0-9]/g, '');">
</div>

      <button type="submit" id="btn-registrar">Registrar Proveedor</button>  
    </form>
<!-- Botón volver a home -->
<div style="text-align: center; margin-top: 25px;">
  <a href="home.php" 
     style="display: inline-block; background-color: #555; color: white; 
            padding: 12px 20px; border-radius: 6px; text-decoration: none;
            font-weight: bold;">
    ⬅ Volver al Menú Principal
  </a>
</div>


    <h2>Proveedores Registrados</h2>
    <table>
      <thead>
        <tr>
          <th>Cédula</th>
          <th>Tipo</th>
          <th>Razón Social</th>
          <th>Contacto</th>
          <th>Dirección</th>
          <th>Teléfono</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $res = $conn->query("SELECT * FROM proveedor ORDER BY razon_social ASC");
        while ($row = $res->fetch_assoc()):
        ?>
        <tr>
          <td><?= htmlspecialchars($row['cedula']) ?></td>
          <td><?= ucfirst($row['tipo_proveedor']) ?></td>
          <td><?= htmlspecialchars($row['razon_social']) ?></td>
          <td><?= htmlspecialchars($row['persona_contacto']) ?></td>
          <td><?= htmlspecialchars($row['direccion']) ?></td>
          <td><?= htmlspecialchars($row['telefono']) ?></td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

<script>
function actualizarPrefijo() {
  const tipo = document.getElementById('tipo_proveedor').value;
  const cedulaInput = document.getElementById('cedula');
  let prefijo = '';

  if (tipo === 'natural') prefijo = 'V-';
  else if (tipo === 'juridico') prefijo = 'J-';
  else if (tipo === 'gubernamental') prefijo = 'G-';

  cedulaInput.value = prefijo;
  cedulaInput.focus();
  cedulaInput.setSelectionRange(prefijo.length, prefijo.length);
  verificarCedula();
}

function validarNumeros() {
  const cedulaInput = document.getElementById('cedula');
  const valor = cedulaInput.value.toUpperCase();
  const match = valor.match(/^(V-|J-|G-)/i);
  const prefijo = match ? match[0].toUpperCase() : '';
  const numeros = valor.substring(prefijo.length).replace(/\D/g, '');

  cedulaInput.value = prefijo + numeros;
  verificarCedula();
}

function verificarCedula() {
  const cedula = document.getElementById('cedula').value.toUpperCase().trim();
  if (cedula.length < 3) return;

  fetch('validar_proveedor.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: 'cedula=' + encodeURIComponent(cedula)
  })
  .then(res => res.json())
  .then(data => {
    const msg = document.getElementById('cedula-msg');
    const btn = document.getElementById('btn-registrar');

    if (data.existe) {
      msg.innerHTML = `⚠️ Este RIF/CEDULA ya está registrado como: <strong>${data.razon}</strong>`;
      msg.style.color = 'red';
      btn.disabled = true;
    } else {
      msg.textContent = '✅ RIF/CEDULA disponible';
      msg.style.color = 'green';
      btn.disabled = false;
    }
  })
  .catch(() => {
    const msg = document.getElementById('cedula-msg');
    msg.textContent = '⚠️ Error al verificar RIF.';
    msg.style.color = 'red';
  });
}
</script>
</body>
</html>

