<?php
session_start();

if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

include 'db.php';

$nombre = $_POST['nombre'];
$contrasena = $_POST['contrasena'];
$rol = $_POST['rol'];

// Validar que el nombre no exista
$verifica = $conn->prepare("SELECT id_usuario FROM usuarios WHERE nombre = ?");
$verifica->bind_param("s", $nombre);
$verifica->execute();
$verifica->store_result();

if ($verifica->num_rows > 0) {
    echo "⚠️ El nombre de usuario ya está registrado.";
    echo '<br><a href="crear_usuario.php">Volver</a>';
    exit;
}

// Hash de la contraseña
$hash = password_hash($contrasena, PASSWORD_DEFAULT);

// Insertar usuario nuevo
$stmt = $conn->prepare("INSERT INTO usuarios (nombre, contrasena, rol) VALUES (?, ?, ?)");
$stmt->bind_param("sss", $nombre, $hash, $rol);

if ($stmt->execute()) {
    echo "✅ Usuario creado correctamente.";
} else {
    echo "❌ Error al crear el usuario.";
}

echo '<br><a href="crear_usuario.php">Crear otro</a>';
echo ' | <a href="dashboard.php">Volver al Panel</a>';
?>
