<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ===========================
    // Sanitizar y capturar datos
    // ===========================

    $rif             = strtoupper(trim($_POST['rif'] ?? ''));
    $razon_social    = strtoupper(trim($_POST['razon_social'] ?? ''));
    $direccion       = strtoupper(trim($_POST['direccion'] ?? ''));
    $chofer          = strtoupper(trim($_POST['chofer'] ?? ''));
    $cedula_chofer   = strtoupper(trim($_POST['cedula_chofer'] ?? ''));
    $telefono_prefijo = $_POST['telefono_prefijo'] ?? '';
    $telefono_numero  = trim($_POST['telefono_numero'] ?? '');
    $telefono         = $telefono_prefijo . '-' . $telefono_numero;

    $vehiculo       = strtoupper(trim($_POST['vehiculo'] ?? ''));
    $peso_tara      = is_numeric($_POST['peso_tara']) ? floatval($_POST['peso_tara']) : null;
    $placa_chuto    = strtoupper(trim($_POST['placa_chuto'] ?? ''));
    $placa_batea    = strtoupper(trim($_POST['placa_batea'] ?? ''));

    $registrado_por = $_SESSION['usuario'];
    $fecha_registro = date("Y-m-d H:i:s");

    // ===========================
    // Validar campos requeridos
    // ===========================
    if (empty($rif) || empty($razon_social) || empty($chofer) || empty($cedula_chofer)) {
        die("❌ Faltan campos requeridos.");
    }

   

    // ===========================
    // Insertar en la base de datos
    // ===========================
    $sql = "INSERT INTO transporte 
        (rif, razon_social, direccion, chofer, cedula_chofer, telefono, vehiculo, peso_tara, placa_chuto, placa_batea, fecha_registro) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Error al preparar la consulta: " . $conn->error);
    }

    $stmt->bind_param("sssssssssss", 
        $rif,
        $razon_social,
        $direccion,
        $chofer,
        $cedula_chofer,
        $telefono,
        $vehiculo,
        $peso_tara,
        $placa_chuto,
        $placa_batea,
        $fecha_registro
    );

    if ($stmt->execute()) {
        $stmt->close();
        header("Location: transporte.php?mensaje=success");
        exit;
    } else {
        echo "❌ Error al guardar: " . $stmt->error;
        $stmt->close();
    }
} else {
    echo "Acceso no permitido.";
}
?>

echo "<script>alert('✅ Proveedor registrado correctamente'); window.location.href = 'transporte.php';</script>";
