<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

require 'db.php';

function desformatear_numero($valor) {
    $valor = str_replace('.', '', $valor);
    $valor = str_replace(',', '.', $valor);
    return floatval($valor);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // GUARDAR EN recepcion_general
    $stmt = $conn->prepare("INSERT INTO recepcion_general (
        control, rif_proveedor, cedula_proveedor, direccion_proveedor, contacto_proveedor,
        doc_referencia, guia_sada, razon_transporte, chofer, cedula_chofer,
        rif_transporte, telefono_transporte, vehiculo, placa_chuto, placa_batea,
        almacen, observaciones
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("sssssssssssssssss",
        $_POST['control'],
        $_POST['rif_proveedor'],
        $_POST['cedula_proveedor'],
        $_POST['direccion_proveedor'],
        $_POST['contacto_proveedor'],
        $_POST['doc_referencia'],
        $_POST['guia_sada'],
        $_POST['razon_transporte'],
        $_POST['chofer'],
        $_POST['cedula_chofer'],
        $_POST['rif_transporte'],
        $_POST['telefono_transporte'],
        $_POST['vehiculo'],
        $_POST['placa_chuto'],
        $_POST['placa_batea'],
        $_POST['almacen'],
        $_POST['observaciones']
    );

    if (!$stmt->execute()) {
        die("Error al guardar la recepción general: " . $stmt->error);
    }

    $id_recepcion = $conn->insert_id;
    $stmt->close();

    // GUARDAR DETALLE
    $codigos        = $_POST['codigo'];
    $descripciones  = $_POST['descripcion'];
    $presentaciones = $_POST['presentacion'];
    $cantidades     = $_POST['cantidad'];
    $pesos_bruto    = $_POST['peso_bruto'];
    $pesos_tara     = $_POST['peso_tara'];
    $pesos_neto     = $_POST['peso_neto'];

    $stmt_detalle = $conn->prepare("INSERT INTO detalle_recepcion (
        id_recepcion, codigo_producto, descripcion, presentacion,
        cantidad, peso_bruto, peso_tara, peso_neto
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    for ($i = 0; $i < count($codigos); $i++) {
        $codigo        = $codigos[$i];
        $descripcion   = $descripciones[$i];
        $presentacion  = $presentaciones[$i];
        $cantidad      = desformatear_numero($cantidades[$i]);
        $peso_bruto    = desformatear_numero($pesos_bruto[$i]);
        $peso_tara     = desformatear_numero($pesos_tara[$i]);
        $peso_neto     = desformatear_numero($pesos_neto[$i]);

        if (empty($codigo) && empty($descripcion)) continue;

        $stmt_detalle->bind_param("isssdddd",
            $id_recepcion,
            $codigo,
            $descripcion,
            $presentacion,
            $cantidad,
            $peso_bruto,
            $peso_tara,
            $peso_neto
        );

        if (!$stmt_detalle->execute()) {
            die("Error al guardar el detalle de productos: " . $stmt_detalle->error);
        }
    }

    $stmt_detalle->close();
    $conn->close();

    header("Location: recepcion.php?success=1&id=$id_recepcion");
    exit;
} else {
    header("Location: recepcion.php");
    exit;
}
