<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}

include 'db.php';

$cedula = $_POST['cedula'];
$tipo = $_POST['tipo_proveedor'];
$razon = $_POST['razon_social'];
$contacto = $_POST['persona_contacto'];
$direccion = $_POST['direccion'];
$telefono_prefijo = $_POST['telefono_prefijo'];
$telefono_numero  = $_POST['telefono_numero'];
$telefono = $telefono_prefijo . '-' . $telefono_numero;


// Evitar duplicados
$check = $conn->prepare("SELECT id_proveedor FROM proveedor WHERE cedula = ?");
$check->bind_param("s", $cedula);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo "<script>alert('⚠️ Este proveedor ya existe'); window.location.href = 'proveedores.php';</script>";
    exit;
}

// Insertar proveedor
$stmt = $conn->prepare("INSERT INTO proveedor (cedula, tipo_proveedor, razon_social, persona_contacto, direccion, telefono)
VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssss", $cedula, $tipo, $razon, $contacto, $direccion, $telefono);
$stmt->execute();

echo "<script>alert('✅ Proveedor registrado correctamente'); window.location.href = 'proveedores.php';</script>";
