<?php
require 'db.php';

if (!isset($_POST['id'])) {
    echo json_encode(['success' => false, 'message' => 'ID no proporcionado']);
    exit;
}

$id = intval($_POST['id']);

$stmt = $conn->prepare("SELECT descripcion, cantidad, peso_bruto, peso_tara, peso_neto FROM detalle_recepcion WHERE id_recepcion = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

$detalles = [];
while ($row = $result->fetch_assoc()) {
    $detalles[] = [
        'descripcion'  => $row['descripcion'],
        'cantidad'     => number_format($row['cantidad'], 2, ',', '.'),
        'peso_bruto'   => number_format($row['peso_bruto'], 2, ',', '.'),
        'peso_tara'    => number_format($row['peso_tara'], 2, ',', '.'),
        'peso_neto'    => number_format($row['peso_neto'], 2, ',', '.'),
    ];
}

echo json_encode(['success' => true, 'detalles' => $detalles]);
