<?php
session_start();
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Login - Planta de Maíz</title>
  <style>
    * {
      box-sizing: border-box;
      font-family: 'Segoe UI', sans-serif;
    }

    body {
      margin: 0;
      padding: 0;
      background-color: #f0fdf4; /* verde muy claro */
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }

    .login-container {
      background-color: #ffffff;
      padding: 40px 30px;
      border-radius: 10px;
      box-shadow: 0 4px 15px rgba(0, 128, 0, 0.2);
      width: 100%;
      max-width: 400px;
    }

    .login-container h2 {
      text-align: center;
      color: #2e7d32; /* verde fuerte */
      margin-bottom: 25px;
    }

    label {
      display: block;
      margin-bottom: 6px;
      color: #333;
      font-weight: 500;
    }

    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 10px 12px;
      border: 1px solid #ccc;
      border-radius: 5px;
      margin-bottom: 20px;
    }

    button {
      width: 100%;
      padding: 12px;
      background-color: #2e7d32; /* verde oscuro */
      color: white;
      font-weight: bold;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      transition: background 0.3s;
    }

    button:hover {
      background-color: #1b5e20;
    }

    .footer {
      text-align: center;
      margin-top: 20px;
      font-size: 14px;
      color: #555;
    }
  </style>
</head>
<body>

  <div class="login-container">
    <h2>Acceso al Sistema</h2>
    <form method="POST" action="validar.php">
      <label for="nombre">Usuario</label>
      <input type="text" name="nombre" id="nombre" required>

      <label for="contrasena">Contraseña</label>
      <input type="password" name="contrasena" id="contrasena" required>

      <button type="submit">Ingresar</button>
    </form>

    <div class="footer">
      Comercializadora Alimentos Oriente, C.A © <?= date('Y') ?>
    </div>
  </div>

</body>
</html>
