<?php
session_start();

// Validar login
if (!isset($_SESSION["id_usuario"])) {
    header("Location: login.php");
    exit();
}

$nombre = $_SESSION["nombre"];
$rol = $_SESSION["rol"];
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Inicio - Sistema Planta de Maíz</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      margin: 0;
      padding: 40px 20px;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4; /* Tono verde muy claro de fondo */
      display: flex;
      flex-direction: column;
      align-items: center;
      min-height: 100vh;
      box-sizing: border-box;
    }

    /* Encabezado */
    .header-info {
      width: 100%;
      max-width: 1200px;
      text-align: center;
      margin-bottom: 30px;
    }
    .header-info h1 {
      color: #2e7d32;
      margin-bottom: 10px;
    }
    .header-info .bienvenida {
      font-size: 18px;
      color: #333;
      margin-bottom: 20px;
    }
    .logout-button {
      display: inline-block;
      padding: 10px 20px;
      font-size: 16px;
      color: white;
      background-color: #d32f2f; /* Botón de salir en rojo */
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      transition: background-color 0.3s;
    }
    .logout-button:hover {
      background-color: #b71c1c;
    }

    /* Contenedor principal para las tarjetas */
    .main-container {
      display: flex;
      flex-wrap: wrap; /* Para que se apilen en pantallas pequeñas */
      justify-content: center;
      gap: 30px;
      width: 100%;
      max-width: 1200px;
      margin: 0 auto;
      flex-grow: 1;
    }

    /* Estilo de cada tarjeta (bloque) */
    .menu-card {
      background-color: white;
      padding: 30px 35px;
      border-radius: 15px;
      box-shadow: 0 10px 25px rgba(0, 128, 0, 0.1);
      text-align: center;
      flex-basis: 300px; /* Ancho base de cada tarjeta */
      flex-grow: 1;
      max-width: 350px;
      box-sizing: border-box;
      display: flex;
      flex-direction: column; /* Alinear contenido verticalmente */
    }

    .menu-card h2 {
      color: #2e7d32;
      margin-top: 0;
      margin-bottom: 25px;
      font-size: 24px;
    }

    /* Estilo de los botones del menú */
    .menu-button {
      display: block;
      width: 100%;
      margin: 10px 0;
      padding: 15px;
      font-size: 17px;
      color: white;
      background-color: #2e7d32; /* Verde principal */
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      transition: background-color 0.3s, transform 0.2s;
      box-sizing: border-box;
      text-align: left; /* Alinear texto a la izquierda */
      padding-left: 20px;
    }
    
    .menu-button i {
      margin-right: 12px; /* Espacio entre icono y texto */
      font-size: 1.1em;
    }

    .menu-button:hover {
      background-color: #1b5e20; /* Verde más oscuro */
      transform: translateY(-2px);
    }

    .spacer {
        flex-grow: 1; /* Empuja el footer de la tarjeta hacia abajo */
    }

    .card-footer {
      margin-top: 30px;
      font-size: 12px;
      color: #aaa;
    }

    /* Footer principal de la página */
    .footer {
      width: 100%;
      text-align: center;
      margin-top: 40px;
      font-size: 14px;
      color: #888;
    }
  </style>
</head>
<body>

  <div class="header-info">
    <h1>Sistema Planta de Maíz</h1>
    <p class="bienvenida">Bienvenido, <strong><?= htmlspecialchars($nombre) ?></strong> (<?= htmlspecialchars($rol) ?>)</p>
    <a href="logout.php" class="logout-button"><i class="bi bi-box-arrow-right"></i> Cerrar Sesión</a>
  </div>

  <div class="main-container">

    <div class="menu-card">
      <h2>Procesos</h2>
      <a href="recepcion.php" class="menu-button"><i class="bi bi-box-seam"></i> Recepción M.P.</a>
      <a href="aprobar_recepciones.php" class="menu-button"><i class="bi bi-check-circle"></i> Aprobar Recepción</a>
      <div class="spacer"></div>
      <div class="card-footer">© <?= date('Y') ?> Comercializadora Alimentos Oriente, C.A</div>
    </div>

    <div class="menu-card">
      <h2>Reportes</h2>
      <a href="stock_almacen.php" class="menu-button"><i class="bi bi-archive"></i> Inventario Almacén</a>
      <a href="reporte_recepciones.php" class="menu-button"><i class="bi bi-archive"></i> Reporte Recepciones</a>
      <div class="spacer"></div>
      <div class="card-footer">© <?= date('Y') ?> Comercializadora Alimentos Oriente, C.A</div>
    </div>

    <?php if ($rol === 'admin'): ?>
      <div class="menu-card">
        <h2>Administración</h2>
        <a href="crear_usuario.php" class="menu-button"><i class="bi bi-person-plus"></i> Crear Usuario</a>
        <a href="registrar_cliente.php" class="menu-button"><i class="bi bi-person-plus"></i> Registrar Cliente</a>
        <a href="transporte.php" class="menu-button"><i class="bi bi-person-plus"></i> Registrar Transporte</a>
	<a href="proveedores.php" class="menu-button"><i class="bi bi-person-plus"></i> Registrar Proveedor</a>
        <a href="lista_usuarios.php" class="menu-button"><i class="bi bi-people"></i> Lista de Usuarios</a>
        <div class="spacer"></div>
        <div class="card-footer">© <?= date('Y') ?> Comercializadora Alimentos Oriente, C.A</div>
      </div>
    <?php endif; ?>

  </div>

  <div class="footer">© <?= date('Y') ?> Comercializadora Alimentos Oriente, C.A</div>

</body>
</html>