<?php
session_start();

// Validar sesión y rol de administrador
if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// Aquí puedes poner la lógica si el formulario se envía a sí mismo (opcional)
$mensaje = "";
$mensaje_tipo = ""; // 'success' o 'error'

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Esto es un ejemplo, deberías mover tu lógica de 'procesar_usuario.php' aquí
    // require 'db.php';
    // $nombre = $_POST['nombre'];
    // $contrasena = password_hash($_POST['contrasena'], PASSWORD_BCRYPT);
    // $rol = $_POST['rol'];
    
    // $stmt = $conn->prepare("INSERT INTO usuarios (nombre, contrasena, rol) VALUES (?, ?, ?)");
    // $stmt->bind_param("sss", $nombre, $contrasena, $rol);
    
    // if ($stmt->execute()) {
    //     $mensaje = "✅ ¡Usuario creado con éxito!";
    //     $mensaje_tipo = "success";
    // } else {
    //     $mensaje = "❌ Error al crear el usuario: " . $stmt->error;
    //     $mensaje_tipo = "error";
    // }
    // $stmt->close();
    // $conn->close();
    
    // Por ahora, solo simularemos que se procesa en otro lado
    // Si prefieres mantener 'procesar_usuario.php' separado, puedes borrar este bloque if.
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Crear Usuario</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4; /* Fondo verde claro */
      padding: 40px 20px;
    }
    .container {
      max-width: 600px;
      margin: auto;
      background: #fff;
      padding: 30px 40px;
      border-radius: 15px;
      box-shadow: 0 10px 25px rgba(0, 128, 0, 0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32; /* Verde principal */
      margin-bottom: 30px;
      font-weight: 700;
    }
    .form-label {
      font-weight: 600;
      color: #2e7d32;
    }
    .form-control, .form-select {
      border: 1px solid #ccc;
      border-radius: 8px;
      padding: 10px 15px;
    }
    .form-control:focus, .form-select:focus {
      border-color: #2e7d32;
      box-shadow: 0 0 0 0.25rem rgba(46, 125, 50, 0.25);
    }
    .boton {
      padding: 12px 20px;
      font-size: 16px;
      background-color: #2e7d32;
      color: white;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      display: inline-block;
      transition: background-color 0.3s;
      width: 100%;
      font-weight: 600;
    }
    .boton:hover {
      background-color: #1b5e20;
    }
    .boton-volver {
      display: inline-block;
      text-decoration: none;
      color: #555;
      margin-top: 20px;
      font-size: 15px;
    }
    .boton-volver i {
      margin-right: 5px;
    }
    .boton-volver:hover {
      color: #2e7d32;
    }
    .alert-success {
        background-color: #e8f5e9;
        color: #1b5e20;
        border-color: #c8e6c9;
    }
    .alert-error {
        background-color: #fbe9e7;
        color: #b71c1c;
        border-color: #ffcdd2;
    }
  </style>
</head>
<body>

  <div class="container">
    <h2><i class="bi bi-person-plus-fill"></i> Crear Nuevo Usuario</h2>

    <?php if ($mensaje): ?>
        <div class="alert <?= $mensaje_tipo === 'success' ? 'alert-success' : 'alert-error' ?>" role="alert">
            <?= htmlspecialchars($mensaje) ?>
        </div>
    <?php endif; ?>

    <form action="procesar_usuario.php" method="POST">
      
      <div class="mb-3">
        <label for="nombre" class="form-label">Nombre de usuario:</label>
        <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Ej: jgarcia" required>
      </div>

      <div class="mb-3">
        <label for="contrasena" class="form-label">Contraseña:</label>
        <input type="password" class="form-control" id="contrasena" name="contrasena" placeholder="Mínimo 8 caracteres" required>
      </div>

      <div class="mb-3">
        <label for="rol" class="form-label">Rol del Usuario:</label>
        <select class="form-select" id="rol" name="rol" required>
          <option value="" disabled selected>-- Selecciona un rol --</option>
          <option value="admin">Admin</option>
          <option value="operador">Operador</option>
          <option value="calidad">Calidad</option>
          <option value="seguridad">Seguridad</option>
          <option value="gerencia">Gerencia</option>
        </select>
      </div>

      <button type="submit" class="boton"><i class="bi bi-check-lg"></i> Crear Usuario</button>
    </form>

    <div class="text-center">
        <a href="home.php" class="boton-volver"><i class="bi bi-arrow-left-circle"></i> Volver al Inicio</a>
    </div>
  </div>

</body>
</html>