<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['razon_social'])) {
    $razon = trim($_POST['razon_social']);

    // Buscar choferes de esa empresa
    $stmt = $conn->prepare("SELECT DISTINCT chofer FROM transporte WHERE razon_social = ?");
    $stmt->bind_param("s", $razon);
    $stmt->execute();
    $result = $stmt->get_result();

    $choferes = [];
    while ($row = $result->fetch_assoc()) {
        $choferes[] = $row['chofer'];
    }
    $stmt->close();

    // Buscar vehículos únicos registrados para esa empresa
    $stmt2 = $conn->prepare("SELECT DISTINCT vehiculo FROM transporte WHERE razon_social = ?");
    $stmt2->bind_param("s", $razon);
    $stmt2->execute();
    $result2 = $stmt2->get_result();

    $vehiculos = [];
    while ($row2 = $result2->fetch_assoc()) {
        $vehiculos[] = $row2['vehiculo'];
    }
    $stmt2->close();

    echo json_encode([
        'success' => true,
        'choferes' => $choferes,
        'vehiculos' => $vehiculos
    ]);
    exit;
}

echo json_encode(['success' => false, 'message' => 'Petición inválida']);
exit;

