<?php
require 'db.php';

if (!isset($_POST['chofer'])) {
    echo json_encode(['success' => false, 'message' => 'Chofer no recibido']);
    exit;
}

$chofer = trim($_POST['chofer']);

$stmt = $conn->prepare("SELECT cedula, rif, razon_social, telefono, vehiculo, placa_chuto, placa_batea 
                        FROM transporte WHERE chofer = ? LIMIT 1");
$stmt->bind_param("s", $chofer);
$stmt->execute();

// Usamos bind_result para evitar get_result()
$stmt->bind_result($cedula, $rif, $razon_social, $telefono, $vehiculo, $placa_chuto, $placa_batea);

if ($stmt->fetch()) {
    echo json_encode([
        'success' => true,
        'data' => [
            'cedula' => $cedula,
            'rif' => $rif,
            'razon_social' => $razon_social,
            'telefono' => $telefono,
            'vehiculo' => $vehiculo,
            'placa_chuto' => $placa_chuto,
            'placa_batea' => $placa_batea
        ]
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Chofer no encontrado.']);
}

$stmt->close();
$conn->close();
?>

