<?php
require 'db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['rif'])) {
    $rif = trim($_POST['rif']);

    $stmt = $conn->prepare("SELECT cedula, razon_social, direccion, persona_contacto FROM proveedor WHERE cedula = ?");
    $stmt->bind_param("s", $rif);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        echo json_encode([
            'success' => true,
            'data' => $row
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Proveedor no encontrado']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Petición inválida']);
}
?>
