<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['razon_social'], $_POST['vehiculo'])) {
    $razon = trim($_POST['razon_social']);
    $vehiculo = trim($_POST['vehiculo']);

    $stmt = $conn->prepare("SELECT placa_chuto, placa_batea FROM transporte WHERE razon_social = ? AND vehiculo = ?");
    $stmt->bind_param("ss", $razon, $vehiculo);
    $stmt->execute();
    $stmt->store_result();
    $stmt->bind_result($placa_chuto, $placa_batea);

    $placas_chuto = [];
    $placas_batea = [];

    while ($stmt->fetch()) {
        if (!in_array($placa_chuto, $placas_chuto)) {
            $placas_chuto[] = $placa_chuto;
        }
        if (!empty($placa_batea) && !in_array($placa_batea, $placas_batea)) {
            $placas_batea[] = $placa_batea;
        }
    }

    echo json_encode([
        'success' => true,
        'placas_chuto' => $placas_chuto,
        'placas_batea' => $placas_batea
    ]);
    $stmt->close();
    $conn->close();
    exit;
}

echo json_encode(['success' => false, 'message' => 'Petición inválida']);
exit;
