<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chofer']) && isset($_POST['razon_social'])) {
    $chofer = trim($_POST['chofer']);
    $razon_social = trim($_POST['razon_social']);

    $stmt = $conn->prepare("SELECT cedula, rif, telefono, vehiculo, placa_chuto, placa_batea 
                            FROM transporte 
                            WHERE chofer = ? AND razon_social = ? LIMIT 1");
    $stmt->bind_param("ss", $chofer, $razon_social);
    $stmt->execute();
    $stmt->bind_result($cedula, $rif, $telefono, $vehiculo, $placa_chuto, $placa_batea);

    if ($stmt->fetch()) {
        echo json_encode([
            'success' => true,
            'data' => [
                'cedula' => $cedula,
                'rif' => $rif,
                'telefono' => $telefono,
                'vehiculo' => $vehiculo,
                'placa_chuto' => $placa_chuto,
                'placa_batea' => $placa_batea
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Chofer no encontrado']);
    }

    $stmt->close();
    $conn->close();
    exit;
}

echo json_encode(['success' => false, 'message' => 'Petición inválida']);
exit;

