<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
  header("Location: login.php");
  exit;
}

require 'db.php';

$mensaje = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nuevo_formato = trim($_POST['formato_control']);

  if ($nuevo_formato !== "") {
    $stmt = $conn->prepare("INSERT INTO configuracion_general (nombre, valor)
                            VALUES ('formato_control', ?)
                            ON DUPLICATE KEY UPDATE valor = ?");
    $stmt->bind_param("ss", $nuevo_formato, $nuevo_formato);
    if ($stmt->execute()) {
      $mensaje = "Formato actualizado correctamente.";
    } else {
      $mensaje = "Error al actualizar: " . $stmt->error;
    }
    $stmt->close();
  }
}

$res = $conn->query("SELECT valor FROM configuracion_general WHERE nombre = 'formato_control'");
$row = $res->fetch_assoc();
$formato_actual = $row ? $row['valor'] : '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Configuración General</title>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 600px;
      margin: auto;
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32;
      margin-bottom: 20px;
    }
    fieldset {
      border: 1px solid #ccc;
      padding: 15px;
      margin-bottom: 20px;
      border-radius: 6px;
    }
    legend {
      font-weight: bold;
      color: #2e7d32;
    }
    label {
      display: block;
      margin-top: 10px;
      font-weight: 500;
    }
    input, select, textarea {
      width: 100%;
      padding: 8px;
      margin-top: 5px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    .boton {
      background-color: #2e7d32;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      margin-top: 20px;
      width: 100%;
    }
    .boton:hover {
      background-color: #1b5e20;
    }
    .mensaje {
      background-color: #e8f5e9;
      padding: 10px;
      color: #2e7d32;
      border-left: 5px solid #43a047;
      margin-bottom: 20px;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Configuración General</h2>

    <?php if ($mensaje): ?>
      <div class="mensaje"><?= htmlspecialchars($mensaje) ?></div>
    <?php endif; ?>

    <form method="post">
      <fieldset>
        <legend>Formato de Control</legend>
        <label for="formato_control">Formato actual:</label>
        <input type="text" name="formato_control" id="formato_control" value="<?= htmlspecialchars($formato_actual) ?>" required placeholder="Ej: 0000001">
      </fieldset>
      <button type="submit" class="boton">Guardar Formato</button>
    </form>
  </div>
</body>
</html>

