<?php 
require 'auth.php';
require 'db.php';

if (!isset($_POST['id_recepcion']) || !isset($_SESSION['usuario'])) {
    die("Acceso no autorizado.");
}

$id_recepcion = intval($_POST['id_recepcion']);
$usuario_aprueba = $_SESSION['usuario'];
$fecha_actual = date("Y-m-d H:i:s");

// Actualizar la recepción
$stmt = $conn->prepare("UPDATE recepcion_general 
    SET status = 'APROBADO', aprobado_por = ?, fecha_aprobacion = ?
    WHERE id_recepcion = ?");

$stmt->bind_param("ssi", $usuario_aprueba, $fecha_actual, $id_recepcion);

if ($stmt->execute()) {
    $stmt->close();
    $conn->close();
    header("Location: status_recepcion.php?msg=aprobado");
    exit;
} else {
    die("Error al aprobar recepción: " . $stmt->error);
}
?>
